<?php

namespace App\Modules\TempApplication\CustomerAttachment;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustomerAttachment extends Model 
{

    protected $table = 'tmp_customer_attachments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function customer()
    {
        return $this->belongsTo('Customer', 'customer_id');
    }

}